#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#*************************** Configuration ****************************
# Factory_paquets_de_CRIs_gen configuration : See the file :
# ${SCRIPT_HOME_DIR}/paquets_de_CRIs_builder_help_010_configuration_README.txt
# Or follow the tags :
# tag_public_and_private_config_Only_for_private_config_base_value
# tag_public_and_private_config_For_public_config_base_value
#*********************************************************************


# For debug. Set it to "true" to activate the mode debug.
### SCRIPTCTXT_DEBUG="true"
SCRIPTCTXT_DEBUG=""
# For testing. Set it to "true" to activate the mode testing.
# Testing is, as an example, with retrieval of only one page, of the web site, to make the test quickly.
# Note : for HTTrack, the value is defined in the HTTrack launch script.
### SCRIPTCTXT_TESTING_GEN="true"
SCRIPTCTXT_TESTING_GEN=""

SCRIPT_HOME_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
export SCRIPT_HOME_DIR;
THIS_PROCESS_SCRIPT_EXIT_CODE=0;
export THIS_PROCESS_SCRIPT_EXIT_CODE;

# Load the base library of features (logging, chrono, etc...).
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_0200_lib_base_gen.sh"

# Load the configuration.
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_1010_load_configuration_gen.sh"

# Do some checkings, just after the load of the configuration and before to start processing.
# Some general checking, such as if the folder for production storage exists, or create it.
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_1110_checkings_after_configuration_load_before_start_processing.sh"


logging_string_to_loggenfile ""
logging_string_to_loggenfile "The config is loaded, the checkings have been done : will start the process."
logging_string_to_loggenfile ""

# Retrieve the website in tbe data workspace folder. Use HTTrack. 
# HTTrack is not used. WGet is used.
# . "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2100_website_retrieval_processing_with_httrack.sh"

# Retrieve the website in tbe data workspace folder. Use WGet Mirror Website. 
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2200_website_retrieval_processing_with_wget_mirror_website.sh"

# Prepare the files of the retrieved the website, from the data workspace folder. 
# Into the data prodstore folder, as compressed package, with SHA256 hash. 
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2500_packofcris_prepaforprod_processing_main.sh"



# reprendre ici : le process...... !!!!!!!!!

# End of process - log the chronometer infos for the end of process.
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_9510_end_of_process_and_log_chronometer_infos_gen.sh"

exit ${THIS_PROCESS_SCRIPT_EXIT_CODE}


# echo
# echo ========================================================================================
# echo



