#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#************************ Prepare for prod the PackageOfCRIs ************************
# Make the SHA checksum of the folder of files.
#**********************************************************************
# For the Sha command for the folder, see : 
# https://askubuntu.com/questions/1091335/create-checksum-sha256-of-all-files-and-directories#1091369
# For an example of checksum with PGP verification (signature), see :
# https://getfedora.org/en/security/
logging_string_to_loggenfile "Make the SHA checksum of the folder of files."
logging_string_to_loggenfile ""

mkdir -p "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUMUNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER}"
chown "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}" "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUMUNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER}"

# The files names for the checksum files.
# Checksum file for the uncompressed-folder-checksum :
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_UNCOMPRESSEDFOLDER_FILE_NAME="${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}-uncompressed-folder-CHECKSUM"
# In the Data Workspace folder.
PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUM_UNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUMUNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_UNCOMPRESSEDFOLDER_FILE_NAME}"
# In the Data Production Storage folder.
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_UNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_UNCOMPRESSEDFOLDER_FILE_NAME}"

PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME="${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2530_hashing-for-checksum-SHA-256-recursive-on-folders.sh"

# Temporary, (for testing) :
# tag_public_and_private_config_Only_for_private_config_base_value :
### PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME="......./hashing-MD5-SHA-1-SHA-256-for-checksum-of-files-and-recursive-folders/hashing-for-checksum-SHA-256-recursive-on-folders.sh"

#---------------------------------------------------------------
# This is not anymore mandatory, as the checksum file is created in a separate folder (prepa_20_checksumuncompressedfolder).
# But the option is kept as is, for may be later use.
# The option "-wholename './${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/*'" allow to get all the files from the folder, but not the checksum file itself (that will be created in the root folder, aside with the folder to check).
# It avoids the file like : "Paquet_de_CRIs_local-2022_04_16-10h14m59s-CHECKSUM" to be taken in the checksum result file.
#---------------------------------------------------------------
TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD=" ""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}"" \"./ -name '*' -wholename './${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/*' -type f\" ""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUM_UNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}""  ${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE} ${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE} ""NOT_show_only"" ""true"" "

if [ "x${SCRIPTCTXT_DEBUG}" = "xtrue" ]
then
	logging_string_to_loggenfile
	logging_string_to_loggenfile "TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD=${TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD}"
	logging_string_to_loggenfile
fi

# Call the script for the SHA256 checksum of the folder of files.
#### ${PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME} "${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_FULLPATH_CURRENT_FOLDER}" "*" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_UNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"  "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}" "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}" "show_only" "true"

### ${PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME} ${TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD}

#---------------------------------------------------------------
# This is not anymore mandatory, as the checksum file is created in a separate folder (prepa_20_checksumuncompressedfolder).
# But the option is kept as is, for may be later use.
# The option "-wholename './${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/*'" allow to get all the files from the folder, but not the checksum file itself (that will be created in the root folder, aside with the folder to check).
# It avoids the file like : "Paquet_de_CRIs_local-2022_04_16-10h14m59s-CHECKSUM" to be taken in the checksum result file.
#---------------------------------------------------------------
${PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME} "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}" "./ -name '*' -wholename './${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/*' -type f" "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUM_UNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"  ${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE} ${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE} "NOT_show_only" "true"

TEMP_SCRIPT_EXIT_CODE_1=$?




