#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#*************************** Configuration ****************************
# Factory_paquets_de_CRIs_gen configuration : See the file :
# ${SCRIPT_HOME_DIR}/paquets_de_CRIs_builder_help_010_configuration_README.txt
#*********************************************************************

# paquets_de_CRIs_builder_120_config_PRIVATE_DETAILS_CONF.sh

#*********************************************************************
# Configure the chronometer start, for timestamp of start, elapsed time, etc...
#*********************************************************************
# For timestamp of start, elapsed time, etc...
# Initializes the variables (so the scope is global).
# For date in seconds : see : https://unix.stackexchange.com/questions/314365/get-elapsed-time-in-bash
TIMESTAMP_START=$(date -u +%s)
TIMESTAMP_END=$(date -u +%s)
TIMESTAMP_ELAPSED_1_TIME=$((${TIMESTAMP_END} - ${TIMESTAMP_START}))

TSTP_DATE_TIME_START_SHORT=$(date +'%Y%m%d-%Hh%Mm%Ss')
TSTP_DATE_TIME_START_HUMAN_READ=$(date +'%d %B %Y - %Hh%Ms%S')

TSTP_DATE_TIME_END_SHORT=$(date +'%Y%m%d-%Hh%Mm%Ss')
TSTP_DATE_TIME_END_HUMAN_READ=$(date +'%d %B %Y - %Hh%Ms%S')

TSTP_ELAPSED_1_TIME_HUMAN_READ="not_defiened_yet"

# The labels, for the publication of the chronometer infos.
CHRONO_RESULT_SHOW_10_BEFORE_START_STANDARD=""
CHRONO_RESULT_SHOW_50_AFTER_END_STANDARD=""
CHRONO_PROCESS_NAME_USUAL="${THIS_PAQUET_DE_CRIS_LABEL_TIMESTAMPED_HUMANREADING_USUALFORMAT}"
CHRONO_PROCESS_INFO_10_USUAL="Start the build of the paquet de CRIs."
CHRONO_PROCESS_INFO_20_USUAL=""
CHRONO_PROCESS_INFO_30_USUAL=""

chrono_build_result_befstart_show

#*********************************************************************
# General process variables.
#*********************************************************************
#In the code, to retrieve the exit code of a sub process (httrack, or so...)
# THIS_PROCESS_SCRIPT_EXIT_CODE=$?
THIS_PROCESS_SCRIPT_EXIT_CODE=0

#*********************************************************************
# HTTrack process variables.
#*********************************************************************
# tag_public_and_private_config_Only_for_private_config_base_value :
HTTRACK_SCRIPTS_FULLPATH_ROOT_FOLDER="......HTTrack-Website-Copier-Launcher"
# tag_public_and_private_config_For_public_config_base_value :
HTTRACK_SCRIPTS_FULLPATH_ROOT_FOLDER="${SCRIPT_HOME_DIR}/FactPackCris_210_Scripts_HTTrack"

HTTRACK_SCRIPT_LAUNCHER_MAIN_NAME="httrack-launch-120-Les-CRIs_com-01-For-paquet-de-CRIs-Linux.sh"

#*********************************************************************
# WGet process variables.
#*********************************************************************
# tag_public_and_private_config_Only_for_private_config_base_value :
# WGET_SCRIPTS_FULLPATH_ROOT_FOLDER=".......WGet-Website-Copier-Launcher"
# tag_public_and_private_config_For_public_config_base_value :
WGET_SCRIPTS_FULLPATH_ROOT_FOLDER="${SCRIPT_HOME_DIR}/FactPackCris_220_Scripts_WGet"

WGET_SCRIPT_LAUNCHER_MAIN_NAME="wget-mirror-website-launch-120-Les-CRIs_com-01-For-paquet-de-CRIs-Linux.sh"

logging_string_to_loggenfile ""
logging_string_to_loggenfile "========================================================================================"
logging_string_to_loggenfile "Configuration from details_conf :"
logging_string_to_loggenfile "${NEW_LINE_CHAR}"
logging_string_to_loggenfile "TODO=${TODO}"
logging_string_to_loggenfile ""
logging_string_to_loggenfile "TODO :"
logging_string_to_loggenfile ""
logging_string_to_loggenfile "========================================================================================"
logging_string_to_loggenfile ""



