#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#******************** Lib of base general features *******************
# Some general base features, such as chronometer, logging, etc...
#*********************************************************************

#****************************** Version ******************************
# V_0_1_0 - Version-220413
#*********************************************************************

#*********************************************************************
# Chronometer feature.
#*********************************************************************

chrono_start()
{
TIMESTAMP_START=$(date -u +%s)
TSTP_DATE_TIME_START_SHORT=$(date +'%Y%m%d-%Hh%Mm%Ss')
TSTP_DATE_TIME_START_HUMAN_READ=$(date +'%d %B %Y - %Hh%Ms%S')
}
chrono_end()
{
TIMESTAMP_END=$(date -u +%s)
TSTP_DATE_TIME_END_SHORT=$(date +'%Y%m%d-%Hh%Mm%Ss')
TSTP_DATE_TIME_END_HUMAN_READ=$(date +'%d %B %Y - %Hh%Ms%S')
TIMESTAMP_ELAPSED_1_TIME=$((${TIMESTAMP_END} - ${TIMESTAMP_START}))
}

chrono_build_result_befstart_add_info_and_newline()
{
CHRONO_RESULT_SHOW_10_BEFORE_START_STANDARD="${CHRONO_RESULT_SHOW_10_BEFORE_START_STANDARD}${1}${NEW_LINE_CHAR}"
}
chrono_build_result_befstart_add_newline()
{
CHRONO_RESULT_SHOW_10_BEFORE_START_STANDARD="${CHRONO_RESULT_SHOW_10_BEFORE_START_STANDARD}${NEW_LINE_CHAR}"
}
chrono_build_result_afterend_add_info_and_newline()
{
CHRONO_RESULT_SHOW_50_AFTER_END_STANDARD="${CHRONO_RESULT_SHOW_50_AFTER_END_STANDARD}${1}${NEW_LINE_CHAR}"
}
chrono_build_result_afterend_add_newline()
{
CHRONO_RESULT_SHOW_50_AFTER_END_STANDARD="${CHRONO_RESULT_SHOW_50_AFTER_END_STANDARD}${NEW_LINE_CHAR}"
}
chrono_build_result_show_elapsed_time_formated()
{
secs=$((  TIMESTAMP_ELAPSED_1_TIME % 60    ))  
mins=$((  ( TIMESTAMP_ELAPSED_1_TIME / 60 ) % 60    ))  
hrs=$((  TIMESTAMP_ELAPSED_1_TIME / 3600    ))
TSTP_ELAPSED_1_TIME_HUMAN_READ=`printf "%02dh %02dm %02ds" $hrs $mins $secs`
}
chrono_build_result_befstart_show()
{
chrono_build_result_befstart_add_info_and_newline "##########################################################"
chrono_build_result_befstart_add_info_and_newline "${CHRONO_PROCESS_NAME_USUAL} - ${TSTP_DATE_TIME_START_SHORT}"
chrono_build_result_befstart_add_info_and_newline "${CHRONO_PROCESS_INFO_10_USUAL}"
chrono_build_result_befstart_add_info_and_newline "${CHRONO_PROCESS_INFO_20_USUAL}"
chrono_build_result_befstart_add_info_and_newline "${CHRONO_PROCESS_INFO_30_USUAL}"
chrono_build_result_befstart_add_info_and_newline "##########################################################"
}
chrono_build_result_afterend_show()
{
chrono_build_result_afterend_add_info_and_newline "Start : ${TSTP_DATE_TIME_START_HUMAN_READ}"
chrono_build_result_afterend_add_info_and_newline "End : ${TSTP_DATE_TIME_END_HUMAN_READ}"
chrono_build_result_afterend_add_info_and_newline "Elapsed time : ${TIMESTAMP_ELAPSED_1_TIME}s"
chrono_build_result_show_elapsed_time_formated
chrono_build_result_afterend_add_info_and_newline "Elapsed time : ${TSTP_ELAPSED_1_TIME_HUMAN_READ}"
}

#*********************************************************************
# Logging and logger feature.
#*********************************************************************
logging_string_to_loggenfile()
{
echo "${1}" 
echo "${1}" >> "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}"
}
logging_string_noecho_to_loggenfile()
{
echo "${1}" >> "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}"
}
logging_string_to_logerrorfile()
{
echo "${1}" 
echo "${1}" >> "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}"
}

logging_result_befstart_to_loggenfile()
{
# Adding at the end of the file.
# Adding on top of file is to complicated to worth making it.
logging_string_to_loggenfile "${CHRONO_RESULT_SHOW_10_BEFORE_START_STANDARD}"
}
logging_result_afterend_to_loggenfile()
{
logging_string_to_loggenfile "${CHRONO_RESULT_SHOW_50_AFTER_END_STANDARD}"
}


check_logs_files()
{
# If not there, create the logs files, and set the owner and group to "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}".
LOG_MSG_LOGS_FILES_CREATED=""
if [ ! -f "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}" ]; then
	mkdir -p $(dirname "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}")
	chown "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}" $(dirname "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}")
	touch "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}"
	chown "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}" "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}"
	
	LOG_MSG_LOGS_FILES_CREATED="${NEW_LINE_CHAR}${NEW_LINE_CHAR}**** ---------------------- LOGS_FILES_CREATED ---------------------- ****"
	LOG_MSG_LOGS_FILES_CREATED="${LOG_MSG_LOGS_FILES_CREATED}  ${NEW_LINE_CHAR}The general log file is created : "
    LOG_MSG_LOGS_FILES_CREATED="${LOG_MSG_LOGS_FILES_CREATED} ${NEW_LINE_CHAR}${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}"
    LOG_MSG_LOGS_FILES_CREATED="${LOG_MSG_LOGS_FILES_CREATED} ${NEW_LINE_CHAR}****------------------------------------------------------**** "
fi
# Do some echo, before the logging feature is available.
### echo ""
### echo ""
### echo ""
### echo "LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE=${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}"
### echo ""
### echo ""
### echo ""
### echo "*****************************************"

if [ ! -f "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}" ]; then
	mkdir -p $(dirname "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}")
	chown "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}" $(dirname "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}")
	touch "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}"
	chown "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}" "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}"
	
	LOG_MSG_LOGS_FILES_CREATED="${LOG_MSG_LOGS_FILES_CREATED} ${NEW_LINE_CHAR}${NEW_LINE_CHAR}**** ---------------------- LOGS_FILES_CREATED ---------------------- ****"
	LOG_MSG_LOGS_FILES_CREATED="${LOG_MSG_LOGS_FILES_CREATED}  ${NEW_LINE_CHAR}The error log file is created : "
    LOG_MSG_LOGS_FILES_CREATED="${LOG_MSG_LOGS_FILES_CREATED} ${NEW_LINE_CHAR}${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}"
    LOG_MSG_LOGS_FILES_CREATED="${LOG_MSG_LOGS_FILES_CREATED} ${NEW_LINE_CHAR}****------------------------------------------------------**** "
fi
	
if [ ! "x${LOG_MSG_LOGS_FILES_CREATED}" = "x" ]; then
	# Do some echo, before the logging feature is available.
	echo "${LOG_MSG_LOGS_FILES_CREATED}"
	logging_string_to_loggenfile "${LOG_MSG_LOGS_FILES_CREATED}"
fi
}

# Build the general and error files fullpath and names.
# /fullpath.../[prefix_name]-[timestamps]-gen.log
# /fullpath.../[prefix_name]-[timestamps]-error.log
# Parameters :
# 1 : fulpath of the folder for the log files.
# 2 : prefix for the log files names
# 3 : timestamp to add for the name
build_logs_files_fullpath_and_names_with_timestamp()
{
LOGS_FILES_FULLPATH_ROOT_FOLDER_TO_USE="${1}"
LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE="${1}/${2}-${3}-gen.log"
LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE="${1}/${2}-${3}-error.log"
}

#*********************************************************************
# Folders and files feature.
#*********************************************************************

# Parameters :
# 1 : folder fullpath to check.
# 2 : "true", for logging with error message. If false, then do a simple message to tell that the folder is created.
# 3 : NO_LOG_ONLY_ECHO, if "true", then will only echo the messages. No use of the log feature. This is usefull before the log feature is started.
# 4 : The piece of message added to the error message, or comments messages. 
check_folder_exist_or_create_it()
{
FOLDER_FULLPATH_TO_CHECK=$1
LOG_WITH_ERROR_MSG=$2
NO_LOG_ONLY_ECHO=$3
LOG_PIECE_OF_MESSAGE_TITLE_GEN=$4

if [ "x${LOG_PIECE_OF_MESSAGE_TITLE_GEN}" = "x" ]; then
	LOG_PIECE_OF_MESSAGE_TO_USE_TITLE_GEN="no_message_defined"
else
	LOG_PIECE_OF_MESSAGE_TO_USE_TITLE_GEN="${LOG_PIECE_OF_MESSAGE_TITLE_GEN}"
fi

ERROR_MSG_DEST_FOLDER_NOT_EXIST=""
if [ ! -d "${FOLDER_FULLPATH_TO_CHECK}" ]; then
	if [ "x${LOG_WITH_ERROR_MSG}" = "xtrue" ]; then
		ERROR_MSG_DEST_FOLDER_NOT_EXIST="${NEW_LINE_CHAR}${NEW_LINE_CHAR}**** ---------------------- ERROR ---------------------- ****"
		ERROR_MSG_DEST_FOLDER_NOT_EXIST="${ERROR_MSG_DEST_FOLDER_NOT_EXIST}  ${NEW_LINE_CHAR}****------------------------------------------------------****"
	fi	
    ERROR_MSG_DEST_FOLDER_NOT_EXIST="${ERROR_MSG_DEST_FOLDER_NOT_EXIST} ${NEW_LINE_CHAR}The folder is not found ! ${LOG_PIECE_OF_MESSAGE_TO_USE_TITLE_GEN} ${NEW_LINE_CHAR}${FOLDER_FULLPATH_TO_CHECK}${NEW_LINE_CHAR}"
    ERROR_MSG_DEST_FOLDER_NOT_EXIST="${ERROR_MSG_DEST_FOLDER_NOT_EXIST}This folder will be created, with owner and group : ${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}"
	if [ "x${LOG_WITH_ERROR_MSG}" = "xtrue" ]; then
	    ERROR_MSG_DEST_FOLDER_NOT_EXIST="${ERROR_MSG_DEST_FOLDER_NOT_EXIST} ${NEW_LINE_CHAR}****------------------------------------------------------**** ${NEW_LINE_CHAR}**** ---------------------- ERROR ---------------------- ****"
	fi
	if [ "x${NO_LOG_ONLY_ECHO}" = "xtrue" ]; then
		echo "${ERROR_MSG_DEST_FOLDER_NOT_EXIST}"
	else
		if [ "x${LOG_WITH_ERROR_MSG}" = "xtrue" ]; then
			logging_string_to_logerrorfile "${ERROR_MSG_DEST_FOLDER_NOT_EXIST}"
			logging_string_noecho_to_loggenfile "${ERROR_MSG_DEST_FOLDER_NOT_EXIST}"
		else
			logging_string_to_loggenfile "${ERROR_MSG_DEST_FOLDER_NOT_EXIST}"
		fi
	fi
	mkdir -p "${FOLDER_FULLPATH_TO_CHECK}"
	chown "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}" "${FOLDER_FULLPATH_TO_CHECK}"
fi
}

##### A_FAIRE : not used... so to keep for sample of code, or to erase...

check_folder_dest_backupspace()
{
# Do not create the folder : if not there, it means there is a problem, so stop and alert about the ERROR.
### mkdir -p $FOLDER_DEST_ROOT$FOLDER_DEST_BKPSPACE
ERROR_MSG_DEST_FOLDER_NOT_EXIST=""
if [ ! -d "${FOLDER_DEST_ROOT}/${FOLDER_DEST_BKPSPACE}" ]; then
	ERROR_MSG_DEST_FOLDER_NOT_EXIST="${NEW_LINE_CHAR}${NEW_LINE_CHAR}**** ---------------------- ERROR ---------------------- ****"
	ERROR_MSG_DEST_FOLDER_NOT_EXIST="${ERROR_MSG_DEST_FOLDER_NOT_EXIST}  ${NEW_LINE_CHAR}****------------------------------------------------------****"
    ERROR_MSG_DEST_FOLDER_NOT_EXIST="${ERROR_MSG_DEST_FOLDER_NOT_EXIST} ${NEW_LINE_CHAR}ERROR ! the backup destination folder is not found !${NEW_LINE_CHAR}The folder is : ${FOLDER_DEST_ROOT}/${FOLDER_DEST_BKPSPACE}${NEW_LINE_CHAR}${NEW_LINE_CHAR}Please, check that the backup drive is the proper one."
    ERROR_MSG_DEST_FOLDER_NOT_EXIST="${ERROR_MSG_DEST_FOLDER_NOT_EXIST} ${NEW_LINE_CHAR}${NEW_LINE_CHAR}If this is a new drive, please, create the folder (with owner root) before to launch this backup. ${NEW_LINE_CHAR}mkdir -p ${FOLDER_DEST_ROOT}/${FOLDER_DEST_BKPSPACE}"
    ERROR_MSG_DEST_FOLDER_NOT_EXIST="${ERROR_MSG_DEST_FOLDER_NOT_EXIST} ${NEW_LINE_CHAR}****------------------------------------------------------**** ${NEW_LINE_CHAR}**** ---------------------- ERROR ---------------------- ****"
	
	echo "${ERROR_MSG_DEST_FOLDER_NOT_EXIST}"
	logging_string_to_logerrorfile "${ERROR_MSG_DEST_FOLDER_NOT_EXIST}"
	exit -1
fi
}

