#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#*************************** Configuration ****************************
# Factory_paquets_de_CRIs_gen configuration : See the file :
# ${SCRIPT_HOME_DIR}/paquets_de_CRIs_builder_help_010_configuration_README.txt
#*********************************************************************


# tag_public_and_private_config_Only_for_private_config_base_value
SCRIPT_CONFIG_PRIVATE_FULLPATH_ROOT_FOLDER="${SCRIPT_HOME_DIR}/../Factory_paquets_de_CRIs_config_private_V_0_1_0/FactPackCris_120_Scripts_Config_Gen_Private"
# tag_public_and_private_config_For_public_config_base_value
SCRIPT_CONFIG_PUBLIC_FULLPATH_ROOT_FOLDER="${SCRIPT_HOME_DIR}/FactPackCris_110_Scripts_Config_Gen_Public"

# Set if it will use the Config_Private, or the Config_Public folder.
if [ -d "${SCRIPT_CONFIG_PRIVATE_FULLPATH_ROOT_FOLDER}" ]
then
	SCRIPT_CONFIG_TO_USE_FULLPATH_ROOT_FOLDER="${SCRIPT_CONFIG_PRIVATE_FULLPATH_ROOT_FOLDER}"
	SCRIPT_CONFIG_TO_USE_IS_PUBLIC_CONFIG="false"
	SCRIPT_CONFIG_TO_USE_LABEL="Config_Gen_Private"
else
	SCRIPT_CONFIG_TO_USE_FULLPATH_ROOT_FOLDER="${SCRIPT_CONFIG_PUBLIC_FULLPATH_ROOT_FOLDER}"
	SCRIPT_CONFIG_TO_USE_IS_PUBLIC_CONFIG="true"
	SCRIPT_CONFIG_TO_USE_LABEL="Config_Gen_Public"
fi

# For debug.
echo 
echo Configuration of Factory_paquets_de_CRIs_gen : Load the configuration.
echo
echo ========================================================================================
echo "SCRIPT_HOME_DIR=$SCRIPT_HOME_DIR"
echo "SCRIPT_CONFIG_PRIVATE_FULLPATH_ROOT_FOLDER=${SCRIPT_CONFIG_PRIVATE_FULLPATH_ROOT_FOLDER}"
echo "SCRIPT_CONFIG_PUBLIC_FULLPATH_ROOT_FOLDER=${SCRIPT_CONFIG_PUBLIC_FULLPATH_ROOT_FOLDER}"
echo 
echo "The ${SCRIPT_CONFIG_TO_USE_LABEL} is used."
echo 
echo "Config used :"
echo "SCRIPT_CONFIG_TO_USE_IS_PUBLIC_CONFIG=${SCRIPT_CONFIG_TO_USE_IS_PUBLIC_CONFIG}"
echo "SCRIPT_CONFIG_TO_USE_LABEL=${SCRIPT_CONFIG_TO_USE_LABEL}"
echo
echo "SCRIPT_CONFIG_TO_USE_FULLPATH_ROOT_FOLDER=${SCRIPT_CONFIG_TO_USE_FULLPATH_ROOT_FOLDER}"
echo ========================================================================================
echo 

SCRIPT_CONFIG_PUBLIC_BASE_CONF_FILE_NAME="paquets_de_CRIs_builder_010_config_public_base_conf.sh"
SCRIPT_CONFIG_PRIVATE_BASE_CONF_FILE_NAME="paquets_de_CRIs_builder_110_config_private_base_conf.sh"

# Launch the base_conf script file.
# Use the Config_Private, or the Config_Public folder.
if [ "x${SCRIPT_CONFIG_TO_USE_IS_PUBLIC_CONFIG}" = "xtrue" ]
then
	# Use the public config.
. "${SCRIPT_CONFIG_PUBLIC_FULLPATH_ROOT_FOLDER}/${SCRIPT_CONFIG_PUBLIC_BASE_CONF_FILE_NAME}"
else
	# Use the private config.
. "${SCRIPT_CONFIG_PRIVATE_FULLPATH_ROOT_FOLDER}/${SCRIPT_CONFIG_PRIVATE_BASE_CONF_FILE_NAME}"
fi

# Note : These details_conf files names are defined in the base_conf file.
# SCRIPT_CONFIG_PUBLIC_DETAILS_CONF_FILE_NAME="paquets_de_CRIs_builder_020_config_public_details_conf.sh"
# SCRIPT_CONFIG_PRIVATE_DETAILS_CONF_FILE_NAME="paquets_de_CRIs_builder_120_config_private_details_conf.sh"

# Launch the details_conf script file.
# Use the Config_Private, or the Config_Public folder.
if [ "x${SCRIPT_CONFIG_TO_USE_IS_PUBLIC_CONFIG}" = "xtrue" ]
then
	# Use the public config.
. "${SCRIPT_CONFIG_PUBLIC_FULLPATH_ROOT_FOLDER}/${SCRIPT_CONFIG_PUBLIC_DETAILS_CONF_FILE_NAME}"
else
	# Use the private config.
. "${SCRIPT_CONFIG_PRIVATE_FULLPATH_ROOT_FOLDER}/${SCRIPT_CONFIG_PRIVATE_DETAILS_CONF_FILE_NAME}"
fi


