#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#************************ Prepare for prod the PackageOfCRIs ************************
# Build some tools, as script tools, and Html fragment.
# For providing tools to get the Paquet-de-CRIs from the hosting-server-for-paquets-de-CRIs, to checksum them, and the html fragment with the links to the Paquet-de-CRIs and their checksum files, on the hosting-server-base-for-paquets-de-CRIs.
#**********************************************************************

logging_string_to_loggenfile "Build some tools, as script tools, and Html fragment, into the Data Workspace prepa_60_tools10scriptsandhtmlfragments folder. Tools to automate to get the Paquets-de-CRIs, and html fragment to get them on the hosting-server-base-for-paquets-de-CRIs."
logging_string_to_loggenfile ""
mkdir -p "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_60_TOOLS10SCRIPTSANDHTMLFRAGMENTS_FULLPATH_CURRENT_FOLDER}"
chown "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}" "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_60_TOOLS10SCRIPTSANDHTMLFRAGMENTS_FULLPATH_CURRENT_FOLDER}"

if [ "x" = "xfalse" ]
then

# Add the main paquet-de-CRIs-links-fragments.html in the Data Workspace folder of the Paquet-de-CRIs.
# The source paquet-de-CRIs-links-fragments.html file.
PAQDECRIS_SOURCE_DATA_PAQCRISLINKSFRAGMENTSHTML_FILE_NAME="paquet-de-CRIs-links-fragments.html"
PAQDECRIS_SOURCE_DATA_TOPSRCINDEXHTML_FULLPATH_FOLDER_AND_FILE_NAME="${SCRIPT_HOME_DIR}/FactPackCris_310_Content_Html_Pages/${PAQDECRIS_SOURCE_DATA_TOPSRCINDEXHTML_FILE_NAME}"

# The result paquet-de-CRIs-links-fragments.html file. In PREPA_60_TOOLS10SCRIPTSANDHTMLFRAGMENTS folder.
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_PAQCRISLINKSFRAGMENTSHTML_FILE_NAME="${PAQDECRIS_SOURCE_DATA_PAQCRISLINKSFRAGMENTSHTML_FILE_NAME}"
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_PAQCRISLINKSFRAGMENTSHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_WKSP_PREPA_60_TOOLS10SCRIPTSANDHTMLFRAGMENTS_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_PAQCRISLINKSFRAGMENTSHTML_FILE_NAME}"

# Copy the files from the SourceData folder, into the PREPA_60_TOOLS10SCRIPTSANDHTMLFRAGMENTS folder.
cp -p "${PAQDECRIS_SOURCE_DATA_TOPSRCINDEXHTML_FULLPATH_FOLDER_AND_FILE_NAME}"  "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_PAQCRISLINKSFRAGMENTSHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"
TEMP_SCRIPT_EXIT_CODE_1=$?

# Modify the content of the paquet-de-CRIs-links-fragments.html file, so it has the value of the proper label and folder for this current Paquet-de-CRIs, in it.
sed -i "s/PAQDECRIS_SUBST_TAG_PATH_RELATIVE_TO_MAIN_WWW_FOLDER/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}\/www.les-cris.com/g" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_PAQCRISLINKSFRAGMENTSHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"
TEMP_SCRIPT_EXIT_CODE_2=$?

sed -i "s/PAQDECRIS_SUBST_TAG_TOPROOT_FOLDER_NAME/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/g" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_PAQCRISLINKSFRAGMENTSHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"
TEMP_SCRIPT_EXIT_CODE_3=$?

sed -i "s/PAQDECRIS_SUBST_TAG_PAQUETDECRIS_LABEL_BASE_GENERAL/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/g" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_PAQCRISLINKSFRAGMENTSHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"
TEMP_SCRIPT_EXIT_CODE_4=$?


fi

