#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#************************ Prepare for prod the PackageOfCRIs ************************
# Prepare the files of the retrieved the website, from the data workspace folder. 
# Into the data prodstore folder, as compressed package, with SHA256 hash. 
#**********************************************************************
logging_string_to_loggenfile ""
logging_string_to_loggenfile "Will prepare the retrieved files from the website, that are in the data workspace, into the PackageOfCRIs in the data prodstore folder. Main general process."

#*********************************************************************
# Prepare the configuration for preparation of PackageOfCRIs process. 
#*********************************************************************
# The variables that will be needed to locate the PackageOfCRIs in the data prodstore folder.

# Reminder :
# The fullpath and folder name, of the folder of the Paquet-de-CRIs retrieved website, by HTTrack, in the data workspace.
# It is supposed that the folder name will be built this way, in the HTTrack process.
# PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_CURRENT_FOLDER_NAME="${FOR_HTTRACK_PROCESS_WEB_SITE_NAME_COPIED_USUAL_VALUE}-${THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT}"
# PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_CURRENT_FOLDER_NAME}"

# Reminder :
# The fullpath of the current general folder, that contains the current folder for the Paquet-de-CRIs, in the Data Production Storage folder :
# PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER

# The folders for the preparation steps.
PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/prepa_10_cleaningfiles"
PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUMUNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/prepa_20_checksumuncompressedfolder"
### NOT_USED (yet) : PAQDECRIS_BUILD_DATA_WKSP_PREPA_30_COMPRESSXZ_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/prepa_30_compressxz"
### NOT_USED (yet) : PAQDECRIS_BUILD_DATA_WKSP_PREPA_40_COMPRESSZIP_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/prepa_40_compresszip"
PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCOMPRESSEDPACKAGES_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/prepa_50_checksumcompressedpackages"
PAQDECRIS_BUILD_DATA_WKSP_PREPA_60_TOOLS10SCRIPTSANDHTMLFRAGMENTS_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/prepa_60_tools10scriptsandhtmlfragments"

# The name of the folder, that contains the Paquet-de-CRIs, in the Data Production Storage folder.
# It is the same as the folder name in the workspace folder.
PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME="${PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_CURRENT_FOLDER_NAME}"
# The fullpath of the folder, that contains the Paquet-de-CRIs, in the Data Production Storage folder. 
PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}"


# For debug.
logging_string_to_loggenfile "For debug :"
logging_string_to_loggenfile "PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_CURRENT_FOLDER_NAME=${PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_CURRENT_FOLDER_NAME}"
logging_string_to_loggenfile "PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER=${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}"
logging_string_to_loggenfile "PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME=${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}"
logging_string_to_loggenfile "PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_FULLPATH_CURRENT_FOLDER=${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_FULLPATH_CURRENT_FOLDER}"
logging_string_to_loggenfile ""

# Do the check if error happened. Then report it and exit with exit code = -12.
# This is common for each part of processing, in each prepaforprod script files. 
error_checking_for_prepaprod_processing() 
{
	# For debug.
	### logging_string_to_loggenfile ""
	### logging_string_to_loggenfile "TEMP_SCRIPT_EXIT_CODE_1=${TEMP_SCRIPT_EXIT_CODE_1}"
	### logging_string_to_loggenfile "TEMP_SCRIPT_EXIT_CODE_2=${TEMP_SCRIPT_EXIT_CODE_2}"
	### logging_string_to_loggenfile ""


	if [[ (! "x${TEMP_SCRIPT_EXIT_CODE_1}" = "x0") || (! "x${TEMP_SCRIPT_EXIT_CODE_2}" = "x0") 
			 || (! "x${TEMP_SCRIPT_EXIT_CODE_3}" = "x0") || (! "x${TEMP_SCRIPT_EXIT_CODE_4}" = "x0") 
			 || (! "x${TEMP_SCRIPT_EXIT_CODE_5}" = "x0") || (! "x${TEMP_SCRIPT_EXIT_CODE_6}" = "x0") ]]
	then
	# Log in error log file.
		logging_string_to_loggenfile ""
		logging_string_to_loggenfile "#--------------------ERROR ----------------------"
		logging_string_to_loggenfile "An error occured during the preparation of the Paquet-de-CRIs process. See the Error log file."
		logging_string_to_loggenfile "#--------------------ERROR ----------------------"
		logging_string_to_loggenfile ""
	# Log in error log file.	
		logging_string_to_logerrorfile "#--------------------ERROR Preparation of the Paquet-de-CRIs process ----------------------"
		logging_string_to_logerrorfile "preparation of the Paquet-de-CRIs process : An error occured." 
		logging_string_to_logerrorfile "ERROR : the preparation process exit code is : ${THIS_PROCESS_SCRIPT_EXIT_CODE}."
		logging_string_to_logerrorfile "TEMP_SCRIPT_EXIT_CODE_1=${TEMP_SCRIPT_EXIT_CODE_1}"
		logging_string_to_logerrorfile "TEMP_SCRIPT_EXIT_CODE_2=${TEMP_SCRIPT_EXIT_CODE_2}"
		logging_string_to_logerrorfile "TEMP_SCRIPT_EXIT_CODE_3=${TEMP_SCRIPT_EXIT_CODE_3}"
		logging_string_to_logerrorfile "TEMP_SCRIPT_EXIT_CODE_4=${TEMP_SCRIPT_EXIT_CODE_4}"
		logging_string_to_logerrorfile "TEMP_SCRIPT_EXIT_CODE_5=${TEMP_SCRIPT_EXIT_CODE_5}"
		logging_string_to_logerrorfile "TEMP_SCRIPT_EXIT_CODE_6=${TEMP_SCRIPT_EXIT_CODE_6}"
		logging_string_to_logerrorfile ""
		logging_string_to_logerrorfile "The process will exit with error code : -12"
		logging_string_to_logerrorfile "#--------------------ERROR Preparation of the Paquet-de-CRIs process ----------------------"
		THIS_PROCESS_SCRIPT_EXIT_CODE=-12;
		exit -12;
	fi
}

# Start the preparation.
logging_string_to_loggenfile "The process for the preparation of the PackageOfCRIs is started."
logging_string_to_loggenfile ""


# Put the files from the Data Workspace folder, into the Data prepa_10_cleaningfiles folder. Remove 3 files not needed.
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2530_packofcris_prepaforprod_cleaning_and_index_page.sh"

# Make the SHA checksum of the folder of files.
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2560_packofcris_prepaforprod_sha_checksum_folder_of_files.sh"

# Build the package, as xz compressed file - tar.gz and zip files.
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2590_packofcris_prepaforprod_compression.sh"

# Make the SHA checksum of the compressed-package files (tar.xz, zip).
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2620_packofcris_prepaforprod_sha_checksum_compressed_files.sh"

# Build some tools, as script tools, and Html fragment.
# For providing tools to get the Paquet-de-CRIs from the hosting-server-for-paquets-de-CRIs, to checksum them, and the html fragment with the links to the Paquet-de-CRIs and their checksum files, on the hosting-server-base-for-paquets-de-CRIs.
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2640_packofcris_prepaforprod_tools_10_scripts_and_html_fragment.sh"

# Copy the files from the Data Workspace folder, into the Data Production Storage folder.
. "${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2750_packofcris_prepaforprod_copy_to_dataprod_folder.sh"

logging_string_to_loggenfile ""
logging_string_to_loggenfile "The preparation of the Paquet-de-CRIs process is finished and is ok." 

logging_string_to_loggenfile ""
logging_string_to_loggenfile "End of preparation of the Paquet-de-CRIs process, to build it in the Data Production Storage folder."




