#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#************************ Retrieve the website ************************
# Retrieve the website in tbe data workspace folder. Use WGet Mirror Website. 
#**********************************************************************

logging_string_to_loggenfile ""
logging_string_to_loggenfile "Will launch WGet, to retrieve the website in the data workspace."

#*********************************************************************
# Prepare the configuration for WGet process. 
#*********************************************************************
# The variables that will be needed by the WGet process script.
export THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT;

# Values for WGet process script.
FOR_WGET_PROCESS_DEST_OUTPUT_FOLDER_ROOT_BASE_VALUE="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}"
export FOR_WGET_PROCESS_DEST_OUTPUT_FOLDER_ROOT_BASE_VALUE;

# Values to retrieve after the WGet process script.
FOR_WGET_PROCESS_WEB_SITE_NAME_COPIED_USUAL_VALUE="Paquet_de_CRIs_local"
export FOR_WGET_PROCESS_WEB_SITE_NAME_COPIED_USUAL_VALUE;

# The fullpath and folder name, of the folder of the Paquet-de-CRIs retrieved website, by WGet, in the data workspace.
# It is supposed that the folder name will be built this way, in the WGet process.
PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_CURRENT_FOLDER_NAME="${FOR_WGET_PROCESS_WEB_SITE_NAME_COPIED_USUAL_VALUE}-${THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT}"
PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_CURRENT_FOLDER_NAME}"

# For debug.
### logging_string_to_loggenfile ""
### logging_string_to_loggenfile "PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_FULLPATH_CURRENT_FOLDER=${PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_FULLPATH_CURRENT_FOLDER}"
### logging_string_to_loggenfile ""


# Launch the script in a new shell, so the variable of this script for WGet do not collide with the one of the Build of the Paquet de CRIs. 
logging_string_to_loggenfile "WGet started."

${WGET_SCRIPTS_FULLPATH_ROOT_FOLDER}/${WGET_SCRIPT_LAUNCHER_MAIN_NAME}
THIS_PROCESS_SCRIPT_EXIT_CODE=$?

if [ ! "x${THIS_PROCESS_SCRIPT_EXIT_CODE}" = "x0" ]
then
# Log in error log file.
	logging_string_to_loggenfile ""
	logging_string_to_loggenfile "#--------------------ERROR ----------------------"
	logging_string_to_loggenfile "An error occured during the WGet process. See the Error log file."
	logging_string_to_loggenfile "#--------------------ERROR ----------------------"
	logging_string_to_loggenfile ""
# Log in error log file.	
	logging_string_to_logerrorfile "#--------------------ERROR WGet process ----------------------"
	logging_string_to_logerrorfile "WGet process : An error occured." 
	logging_string_to_logerrorfile "ERROR : the WGet process exit code is : ${THIS_PROCESS_SCRIPT_EXIT_CODE}."
	logging_string_to_logerrorfile "See the WGet logs files for details."
	logging_string_to_logerrorfile "The WGet logs files are the specific logs files. Not the one of the full process for Paquet-de-CRIs."
	logging_string_to_logerrorfile "#--------------------ERROR WGet process ----------------------"
else
	
	logging_string_to_loggenfile ""
	logging_string_to_loggenfile "The WGet process is finished and is ok." 

fi

logging_string_to_loggenfile ""
logging_string_to_loggenfile "End of WGet process, to retrieve the website in the data workspace."




