#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#************************ Prepare for prod the PackageOfCRIs ************************
# Make the SHA checksum of the compressed-package files (tar.xz, zip).
#**********************************************************************
logging_string_to_loggenfile "Make the SHA checksum of the compressed-package files (tar.xz, zip)."
logging_string_to_loggenfile ""

mkdir -p "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCOMPRESSEDPACKAGES_FULLPATH_CURRENT_FOLDER}"
chown "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}" "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCOMPRESSEDPACKAGES_FULLPATH_CURRENT_FOLDER}"

# The files names for the checksum files.
# Checksum file for the compressed-xz-package-checksum :
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_1_COMPRESSEDXZPACKAGE_FILE_NAME="${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}-xz-paquet-CHECKSUM"
# In the Data Workspace folder.
PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCP_1_COMPRESSEDXZPACKAGE_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCOMPRESSEDPACKAGES_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_1_COMPRESSEDXZPACKAGE_FILE_NAME}"
# In the Data Production Storage folder.
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUMCP_1_COMPRESSEDXZPACKAGE_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_1_COMPRESSEDXZPACKAGE_FILE_NAME}"

# The files names for the checksum files.
# Checksum file for the compressed-zip-package-checksum :
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_2_COMPRESSEDZIPPACKAGE_FILE_NAME="${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}-zip-paquet-CHECKSUM"
# In the Data Workspace folder.
PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCP_2_COMPRESSEDZIPPACKAGE_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCOMPRESSEDPACKAGES_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_2_COMPRESSEDZIPPACKAGE_FILE_NAME}"
# In the Data Production Storage folder.
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUMCP_2_COMPRESSEDZIPPACKAGE_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_2_COMPRESSEDZIPPACKAGE_FILE_NAME}"

PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME="${SCRIPT_HOME_DIR}/FactPackCris_010_Scripts_Gen/paqdecris_builder_2530_hashing-for-checksum-SHA-256-recursive-on-folders.sh"

# Temporary, (for testing) :
# tag_public_and_private_config_Only_for_private_config_base_value :
### PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME="......./hashing-MD5-SHA-1-SHA-256-for-checksum-of-files-and-recursive-folders/hashing-for-checksum-SHA-256-recursive-on-folders.sh"

#**********************************************************************
# For the compressed-xz-package-checksum.
#**********************************************************************
# The process uses the script for CHECKSUM_OF_RECURSIVE_FOLDER, though there is only one file.
# This is more easy, but not mandatory.
TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD=" ""${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}"" \"./ -name '${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_XZ_PAQUET_FILE_NAME}' -type f\" ""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCP_1_COMPRESSEDXZPACKAGE_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}""  ${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE} ${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE} ""NOT_show_only"" ""true"" "

if [ "x${SCRIPTCTXT_DEBUG}" = "xtrue" ]
then
	logging_string_to_loggenfile
	logging_string_to_loggenfile "TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD=${TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD}"
	logging_string_to_loggenfile
fi

# Call the script for the SHA256 checksum of the folder of files.
#### ${PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME} "${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_FULLPATH_CURRENT_FOLDER}" "*" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_UNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"  "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}" "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}" "show_only" "true"

### ${PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME} ${TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD}

# The process uses the script for CHECKSUM_OF_RECURSIVE_FOLDER, though there is only one file.
# This is more easy, but not mandatory.
${PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME} "${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}" "./ -name '${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_XZ_PAQUET_FILE_NAME}' -type f" "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCP_1_COMPRESSEDXZPACKAGE_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"  ${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE} ${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE} "NOT_show_only" "true"

TEMP_SCRIPT_EXIT_CODE_1=$?


#**********************************************************************
# For the compressed-zip-package-checksum.
#**********************************************************************
# The process uses the script for CHECKSUM_OF_RECURSIVE_FOLDER, though there is only one file.
# This is more easy, but not mandatory.
TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD=" ""${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}"" \"./ -name '${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_ZIP_PAQUET_FILE_NAME}' -type f\" ""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCP_2_COMPRESSEDZIPPACKAGE_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}""  ${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE} ${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE} ""NOT_show_only"" ""true"" "

if [ "x${SCRIPTCTXT_DEBUG}" = "xtrue" ]
then
	logging_string_to_loggenfile
	logging_string_to_loggenfile "TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD=${TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD}"
	logging_string_to_loggenfile
fi

# Call the script for the SHA256 checksum of the folder of files.
#### ${PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME} "${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_FULLPATH_CURRENT_FOLDER}" "*" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_UNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"  "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}" "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}" "show_only" "true"

### ${PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME} ${TEMP_COMMAND_PARAMETERS_FOR_CHECKSUM_BUILD}

# The process uses the script for CHECKSUM_OF_RECURSIVE_FOLDER, though there is only one file.
# This is more easy, but not mandatory.
${PAQDECRIS_BUILD_LIB_CHECKSUM_OF_RECURSIVE_FOLDER_SCRIPT_FULLPATH_AND_NAME} "${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}" "./ -name '${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_ZIP_PAQUET_FILE_NAME}' -type f" "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_50_CHECKSUMCP_2_COMPRESSEDZIPPACKAGE_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"  ${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE} ${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE} "NOT_show_only" "true"

TEMP_SCRIPT_EXIT_CODE_2=$?




