#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#*************************** Configuration ****************************
# Factory_paquets_de_CRIs_gen configuration : See the file :
# ${SCRIPT_HOME_DIR}/paquets_de_CRIs_builder_help_010_configuration_README.txt
#*********************************************************************

# The details_conf files names.
# Those are defined in the base_conf file, so it is convenient to run the software with some other details conf, for prototyping, for some trials, and tests.
SCRIPT_CONFIG_PUBLIC_DETAILS_CONF_FILE_NAME="paquets_de_CRIs_builder_020_config_public_details_conf.sh"
SCRIPT_CONFIG_PRIVATE_DETAILS_CONF_FILE_NAME="paquets_de_CRIs_builder_120_config_private_details_conf.sh"

# This process timestamp. 
# It is also the timestamp of the paquet-de-CRIs that will be produced.
THIS_PROCESS_TIMESTAMP_BASEFORMAT=$(date +'%Y-%m-%d %H:%M:%S')   # This format is the one that date understand, to make some conversions (here after).
# Timestamp usual : 2022_04_03-11h17m50s
THIS_PROCESS_TIMESTAMP_USUALFORMAT=$(date --date="$THIS_PROCESS_TIMESTAMP_BASEFORMAT" +'%Y_%m_%d-%Hh%Mm%Ss')
# Timestamp human reading : 03-04-2022 11:17:50
THIS_PROCESS_TIMESTAMP_HUMANREADING=$(date --date="$THIS_PROCESS_TIMESTAMP_BASEFORMAT" +'%d-%m-%Y_%H:%M:%S')

# The timestamp of the paquet-de-CRIs that will be produced.
THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT="${THIS_PROCESS_TIMESTAMP_USUALFORMAT}"
THIS_PAQUET_DE_CRIS_TIMESTAMP_HUMANREADING="${THIS_PROCESS_TIMESTAMP_HUMANREADING}"

# Labels
# COMPUTING_FORMAT : no maj char, with dashes, and with timestamps.
THIS_PAQUET_DE_CRIS_LABEL_TIMESTAMPED_COMPUTING_FORMAT="paquets-de-cris_${THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT}"
# USUALFORMAT : with a maj char, with dashes, and with timestamps.
THIS_PAQUET_DE_CRIS_LABEL_TIMESTAMPED_USUALFORMAT="Paquets-de-cris_${THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT}"
# UNDERSCORE_FORMAT : with a maj char, with dashes, and with timestamps.
THIS_PAQUET_DE_CRIS_LABEL_TIMESTAMPED_UNDERSCORE_FORMAT="Paquets_de_cris_${THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT}"
# USUALFORMAT : with a maj char, with dashes, and with timestamps.
THIS_PAQUET_DE_CRIS_LABEL_TIMESTAMPED_HUMANREADING_USUALFORMAT="Paquets-de-cris_${THIS_PAQUET_DE_CRIS_TIMESTAMP_HUMANREADING}"

#*********************************************************************
# Configuration : The data folders for building the Paquet-de-CRIs.
#*********************************************************************
# The fullpath of the general data root folder, for processing and storings the final production packs.
# Do set here the value of the folder path you want the data in.
# tag_public_and_private_config_Only_for_private_config_base_value :
PAQDECRIS_BUILD_DATA_GEN_FULLPATH_ROOT_FOLDER="......"
# tag_public_and_private_config_For_public_config_base_value :
# This places the Data general root folder in the home folder : /home/[your_user_home_folder_name]
PAQDECRIS_BUILD_DATA_GEN_FULLPATH_ROOT_FOLDER="$( cd ""$( dirname "~" )"" && pwd )/les-cris_en_paquets_data_gen"

# The data workspace to retrieve the website data, and process them to build the pack, the hash of the pack, etc.
PAQDECRIS_BUILD_DATA_WORKSPACE_ROOT_FOLDER_NAME="paqdecris-build-data-workspace-gen"
PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_ROOT_FOLDER="${PAQDECRIS_BUILD_DATA_GEN_FULLPATH_ROOT_FOLDER}/${PAQDECRIS_BUILD_DATA_WORKSPACE_ROOT_FOLDER_NAME}"
PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_ROOT_FOLDER}/paqdecris-build-data-workspace-${THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT}"

# The packs in the final production (PACKS_FINAL_PRODUCTION)(packs-final-production)(final-production-pack)(final-prod-pack).
# These packs are the one that have been built, and ready to be used and published.
# The storage folder for the packs in the final production stage, and the hash of the pack, etc.
PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_ROOT_FOLDER_NAME="paqdecris-build-data-final-production-storage-gen"
PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_ROOT_FOLDER="${PAQDECRIS_BUILD_DATA_GEN_FULLPATH_ROOT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_ROOT_FOLDER_NAME}"
PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER="${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_ROOT_FOLDER}/paqdecris-build-data-final-production-storage-${THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT}"

#*********************************************************************
# End of Configuration : The data folders for building the Paquet-de-CRIs.
#*********************************************************************

# The user and groups, for the general process.
# Use the current user and group that launched the script.
# "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}"
UG_GENPROCESS_USER_NAME="$(whoami)"
UG_GENPROCESS_GROUP_NAME="$(id -g -n)"

# For logging and general need of a new line char.
NEW_LINE_CHAR='
'

echo
echo "Will check the folders - for the workspace. And create the log files."
echo

#*********************************************************************
# Check and create the data folders, if not exist. The workspace folder.
#*********************************************************************
# Note : the check for the "The storage folder for the packs in the final production stage" is done later in the process.
# In file : "paqdecris_builder_1110_checkings_after_configuration_load_before_start_processing.sh"
check_folder_exist_or_create_it "${PAQDECRIS_BUILD_DATA_GEN_FULLPATH_ROOT_FOLDER}" "true" "true" "For the Data general root folder"
check_folder_exist_or_create_it "${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_ROOT_FOLDER}" "true" "true"  "For the Workspace root folder"
check_folder_exist_or_create_it "${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}" "false" "true"  "For the Workspace current folder"
check_folder_exist_or_create_it "${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/logs" "false" "true" "For the Logs, in the workspace current folder"

#*********************************************************************
# Configure and set the logger files.
#*********************************************************************
# The logger files configuration values.
# Build the general and error files fullpath and names.
# 1 : fulpath of the folder for the log files.
# 2 : prefix for the log files names
# 3 : timestamp to add for the name
build_logs_files_fullpath_and_names_with_timestamp "${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}/logs" "paqdecris-build-log" "${THIS_PAQUET_DE_CRIS_TIMESTAMP_USUALFORMAT}"

# If not there, create the logs files, and set the owner and group.
check_logs_files

# The logger files configuration values have been set. So the logging feature can be used.
# Start the general file logger, and error file logger.

echo
echo "Start the logging files..."
logging_string_to_loggenfile "##########################################################################"
logging_string_to_loggenfile "# Build of ${THIS_PAQUET_DE_CRIS_LABEL_TIMESTAMPED_USUALFORMAT}"
logging_string_to_loggenfile "# General logs."
logging_string_to_loggenfile "##########################################################################"
logging_string_to_loggenfile ""

logging_string_to_logerrorfile "##########################################################################"
logging_string_to_logerrorfile "# Build of ${THIS_PAQUET_DE_CRIS_LABEL_TIMESTAMPED_USUALFORMAT}"
logging_string_to_logerrorfile "# Error logs."
logging_string_to_logerrorfile "##########################################################################"
logging_string_to_logerrorfile ""


logging_string_to_loggenfile ""
logging_string_to_loggenfile "========================================================================================"
logging_string_to_loggenfile "Configuration from base_conf :${NEW_LINE_CHAR}"
logging_string_to_loggenfile "SCRIPT_CONFIG_PUBLIC_DETAILS_CONF_FILE_NAME=${SCRIPT_CONFIG_PUBLIC_DETAILS_CONF_FILE_NAME}"
logging_string_to_loggenfile "SCRIPT_CONFIG_PRIVATE_DETAILS_CONF_FILE_NAME=${SCRIPT_CONFIG_PRIVATE_DETAILS_CONF_FILE_NAME}"
logging_string_to_loggenfile ""
logging_string_to_loggenfile "Data folders :"
logging_string_to_loggenfile "PAQDECRIS_BUILD_DATA_GEN_FULLPATH_ROOT_FOLDER=${PAQDECRIS_BUILD_DATA_GEN_FULLPATH_ROOT_FOLDER}"
logging_string_to_loggenfile "Data workspace :"
logging_string_to_loggenfile "PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER=${PAQDECRIS_BUILD_DATA_WORKSPACE_FULLPATH_CURRENT_FOLDER}"
j4logging_string_to_loggenfile "Data production storage :"
logging_string_to_loggenfile "PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER=${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}"
logging_string_to_loggenfile ""
logging_string_to_loggenfile "Logger folder :"
logging_string_to_loggenfile "LOGS_FILES_FULLPATH_ROOT_FOLDER_TO_USE=${LOGS_FILES_FULLPATH_ROOT_FOLDER_TO_USE}"
logging_string_to_loggenfile "========================================================================================"
logging_string_to_loggenfile ""



