#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************


# This script is the general script for launching the command of WGet.
# The command is built with all the configuration variable, set in the configuration script, 
# that is runned before to call this one.

###Yet_defined### SCRIPT_WEBSITE_COPIER_HOME_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

COMMAND_GEN="$APPLICATION_WGET_HOME_DIR/$APPLICATION_WGET_EXEC_NAME"

COMMAND_GEN="$COMMAND_GEN $WEB_SITE_URL_GEN"

# Initialize the variable.
WGET_PROCESS_GLOBAL_ERRORS_MESSAGE=""


# Set the return value, for the calling scripts that needs it.
FOR_WGET_PROCESS_RETURNVAL_DEST_OUTPUT_FOLDER_ROOT_FINAL_VALUE="${DEST_OUTPUT_FOLDER_FULLPATH_GEN}"
export FOR_WGET_PROCESS_RETURNVAL_DEST_OUTPUT_FOLDER_ROOT_FINAL_VALUE;

echo ""
echo "FOR_WGET_PROCESS_RETURNVAL_DEST_OUTPUT_FOLDER_ROOT_FINAL_VALUE=${FOR_WGET_PROCESS_RETURNVAL_DEST_OUTPUT_FOLDER_ROOT_FINAL_VALUE}"
echo ""

# Prepare the output folder : Erase the former folder (if no timestamps).
if [ "x$DEST_OUTPUT_OVERWRITE_FORMER_WEBSITE_COPY" = "xtrue" ]
then
	# First check the folder can be erased.
	if [ "x$DEST_OUTPUT_OVERWRITE_FORMER_WEBSITE_COPY_FOLDER_ROOT_FOR_CHECKING" = "x" ]
	then
		echo ""
		echo "!!!!!!!!!!!!!!!!!!!! ERROR !!!!!!!!!!!!!!!!!!!!"
		echo "Cannot erase the former folder !"
		echo "The variable DEST_OUTPUT_OVERWRITE_FORMER_WEBSITE_COPY_FOLDER_ROOT_FOR_CHECKING is null or empty."
		echo "It should contain the folder path to be erased."
		echo "!!!!!!!!!!!!!!!!!!!! END ERROR !!!!!!!!!!!!!!!!!!!!"
		echo ""
		echo ""
		exit -22
	fi
	# Check the folder can be erased : the two variables are equal ?.
	if [ ! "x$DEST_OUTPUT_OVERWRITE_FORMER_WEBSITE_COPY_FOLDER_ROOT_FOR_CHECKING" = "x$DEST_OUTPUT_FOLDER_ROOT" ]
	then
		echo ""
		echo "!!!!!!!!!!!!!!!!!!!! ERROR !!!!!!!!!!!!!!!!!!!!"
		echo "Cannot erase the former folder !"
		echo "The variable DEST_OUTPUT_OVERWRITE_FORMER_WEBSITE_COPY_FOLDER_ROOT_FOR_CHECKING does not contains"
		echo "the same value as the one in the variable : DEST_OUTPUT_FOLDER_ROOT."
		echo "DEST_OUTPUT_OVERWRITE_FORMER_WEBSITE_COPY_FOLDER_ROOT_FOR_CHECKING :"
		echo "$DEST_OUTPUT_OVERWRITE_FORMER_WEBSITE_COPY_FOLDER_ROOT_FOR_CHECKING"
		echo "DEST_OUTPUT_FOLDER_ROOT :"
		echo "$DEST_OUTPUT_FOLDER_ROOT"
		echo "It should contain the same value of the root folder path, so the folder can be erased."
		echo "!!!!!!!!!!!!!!!!!!!! END ERROR !!!!!!!!!!!!!!!!!!!!"
		echo ""
		echo ""
		exit -24
	fi

	# Erase the folder...
	rm -rf $DEST_OUTPUT_FOLDER_FULLPATH_GEN
	# Erase the log folder too, to suppress the cached pages.
	# if not, the former pages are re-given by WGet.
	rm -rf $LOG_WGET_ROOTFOLDER_FULLPATH

fi

# Add the TRACK_SCOPE options
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_TRACK_SCOPE"

# Add the TRACK_SCOPE options
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_01"
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_02"
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_04"
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_05"
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_06"
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_BUILD"
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_SPIDER"
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_07"
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_08"
COMMAND_GEN="$COMMAND_GEN $APP_OPTION_10"


echo 
echo ========================================================================================
echo 
echo Start WGet :
echo
echo "APPLICATION_WGET_HOME_DIR       = $APPLICATION_WGET_HOME_DIR"
echo "APPLICATION_WGET_EXEC_NAME      = $APPLICATION_WGET_EXEC_NAME"
echo "WEB_SITE_URL_BASE          = $WEB_SITE_URL_BASE"
echo "WEB_SITE_URL_GEN           = $WEB_SITE_URL_GEN"
echo "WEB_SITE_NAME_USUAL        = $WEB_SITE_NAME_USUAL"
echo "DEST_OUTPUT_FOLDER_ROOT    = $DEST_OUTPUT_FOLDER_ROOT"
echo "DEST_OUTPUT_FOLDER_NAME    = $DEST_OUTPUT_FOLDER_NAME"
echo "DEST_OUTPUT_FOLDER_ADD_DATETIMESTAMP    = $DEST_OUTPUT_FOLDER_ADD_DATETIMESTAMP"
echo "DEST_OUTPUT_FOLDER_PREDEFINED_DATETIMESTAMP    = $DEST_OUTPUT_FOLDER_PREDEFINED_DATETIMESTAMP"
echo "OutPut Folder              = $DEST_OUTPUT_FOLDER_FULLPATH_GEN"
echo "Logs :"
echo "LOG_WGET_ROOTFOLDER_FULLPATH              = $LOG_WGET_ROOTFOLDER_FULLPATH"
echo "LOG_WGET_GEN_FULLPATH_AND_FILE_NAME                    = ${LOG_WGET_GEN_FULLPATH_AND_FILE_NAME}"
echo "LOG_WGET_ERR_FULLPATH_AND_FILE_NAME                     = ${LOG_WGET_ERR_FULLPATH_AND_FILE_NAME}"
echo "APP_OPTION_TRACK_SCOPE     = $APP_OPTION_TRACK_SCOPE"
echo "APP_OPTION_01              = $APP_OPTION_01"
echo "APP_OPTION_02              = $APP_OPTION_02"
echo "APP_OPTION_04              = $APP_OPTION_04"
echo "APP_OPTION_05              = $APP_OPTION_05"
echo "APP_OPTION_06              = $APP_OPTION_06"
echo "APP_OPTION_BUILD           = $APP_OPTION_BUILD"
echo "APP_OPTION_SPIDER          = $APP_OPTION_SPIDER"
echo "APP_OPTION_07              = $APP_OPTION_07"
echo "APP_OPTION_08              = $APP_OPTION_08"
echo "APP_OPTION_10              = $APP_OPTION_10"
echo
echo "COMMAND_GEN                = $COMMAND_GEN"
echo
echo
echo ========================================================================================
echo

# Create the Output directory.
if [ ! -e "$DEST_OUTPUT_FOLDER_FULLPATH_GEN" ]		# Check OutPut Directory exists.
	then
	mkdir -p "$DEST_OUTPUT_FOLDER_FULLPATH_GEN"
	chown "${UG_WGETPROCESS_USER_NAME}:${UG_WGETPROCESS_GROUP_NAME}" "$DEST_OUTPUT_FOLDER_FULLPATH_GEN"
	chmod u+rwx "$DEST_OUTPUT_FOLDER_FULLPATH_GEN"
	chmod o-rwx "$DEST_OUTPUT_FOLDER_FULLPATH_GEN"
	chmod g-rwx "$DEST_OUTPUT_FOLDER_FULLPATH_GEN"
fi
# Create the log directory.
if [ ! -e "${LOG_WGET_ROOTFOLDER_FULLPATH}" ]		# Check Log Directory exists.
	then
	mkdir -p "${LOG_WGET_ROOTFOLDER_FULLPATH}"
	chown "${UG_WGETPROCESS_USER_NAME}:${UG_WGETPROCESS_GROUP_NAME}" "${LOG_WGET_ROOTFOLDER_FULLPATH}"
	chmod u+rwx "${LOG_WGET_ROOTFOLDER_FULLPATH}"
	chmod o-rwx "${LOG_WGET_ROOTFOLDER_FULLPATH}"
	chmod g-rwx "${LOG_WGET_ROOTFOLDER_FULLPATH}"
fi

echo "Will launch the WGet command in another script file."
exec $COMMAND_GEN


# Check that the grep shell command exist. 
# If not : give explaination, to resolve this trouble with configuration info.
# And exit with error code : -34
if [[ ! -x "${GREP_TOOL_SHELL_COMMAND}" ]]
then
	# Log in error log file.	
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}#--------------------ERROR in configuration ----------------------"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}The variable that indicates the Grep shell command is not propperly defined." 
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}ERROR : the given value is : ${GREP_TOOL_SHELL_COMMAND}"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}No grep executable file is found at this path."
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}Please, do the proper configuration, in the configuration file."
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}The variable to set is : GREP_TOOL_SHELL_COMMAND."
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}#--------------------ERROR in configuration ----------------------"
	
	# Echo then write the log message in the global-end-of-process-errors logs file.
	echo "${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}"
	echo "${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}"  >> "${LOG_WGET_ROOTFOLDER_FULLPATH}/${LOG_WGET_GLOBAL_END_OF_PROCESS_ERRORS_FILE_NAME}"

	# Exit with error code : -34
	exit -34;
fi
#******************************************************
# Check that there was no error.
#******************************************************
# Check that there was no error indicated in the WGet log general file.
# This is necessary, because WGet do no make an exit error code, when some errors occured during dowloading the files.
# When there is NO error, this command return "1". Else it returns 0. 
WGET_PROCESS_IS_WITH_NO_ERROR=$("${GREP_TOOL_SHELL_COMMAND}" -c "(No errors, [0-9]* warnings\?, [0-9]* messages\?)" "${LOG_WGET_GEN_FULLPATH_AND_FILE_NAME}")
# Get the message that says that there are some errors. 
# grep "([0-9]* errors, [0-9]* warnings\?, [0-9]* messages\?)" hts-log.txt
# Gives (example): "(8 errors, 32 warnings, 19 messages)"
WGET_PROCESS_INNER_LOGS_ERRORS_MESSAGE=$("${GREP_TOOL_SHELL_COMMAND}" "(.* errors, [0-9]* warnings\?, [0-9]* messages\?)" "${LOG_WGET_GEN_FULLPATH_AND_FILE_NAME}")

if [ "x${WGET_PROCESS_INNER_LOGS_ERRORS_MESSAGE}" = "x" ]
then
	WGET_PROCESS_INNER_LOGS_ERRORS_MESSAGE=$("${GREP_TOOL_SHELL_COMMAND}" "Error:" "${LOG_WGET_GEN_FULLPATH_AND_FILE_NAME}")
fi

# Build the global-end-of-process-errors message.
if [ ! "x${WGET_PROCESS_IS_WITH_NO_ERROR}" = "x1" ]
then
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}!!!!!!!!!!!!!!!!!!!! ERROR !!!!!!!!!!!!!!!!!!!!"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}There was some error for some pages, or during the process of WGet.${NEW_LINE_CHAR}The detail of inner log error message, with warnings and messages, is : "
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}${WGET_PROCESS_INNER_LOGS_ERRORS_MESSAGE}${NEW_LINE_CHAR}See the log files for details."
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}See the global end of process error log file. ${NEW_LINE_CHAR}The fullpath and name of this file is :"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}LOG_WGET_ROOTFOLDER_FULLPATH=${LOG_WGET_ROOTFOLDER_FULLPATH}"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}LOG_WGET_GLOBAL_END_OF_PROCESS_ERRORS_FILE_NAME=${LOG_WGET_GLOBAL_END_OF_PROCESS_ERRORS_FILE_NAME}"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}See the WGet details logs, in the WGet log file. ${NEW_LINE_CHAR}The fullpath and name of this file is :"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}LOG_WGET_GEN_FULLPATH_AND_FILE_NAME=${LOG_WGET_GEN_FULLPATH_AND_FILE_NAME}"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}!!!!!!!!!!!!!!!!!!!! ERROR !!!!!!!!!!!!!!!!!!!!"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}${NEW_LINE_CHAR}"
# If there was no error.
else
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}No error during WGet process. ${NEW_LINE_CHAR}The detail of inner log error message, with warnings and messages, is : "
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}${WGET_PROCESS_INNER_LOGS_ERRORS_MESSAGE}${NEW_LINE_CHAR}"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}For the warnings and messages, see the WGet details logs, in the WGet log file. ${NEW_LINE_CHAR}The fullpath and name of this file is :"
	WGET_PROCESS_GLOBAL_ERRORS_MESSAGE="${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}${NEW_LINE_CHAR}${LOG_WGET_GEN_FULLPATH_AND_FILE_NAME}"
	
fi

# Echo then write the log message in the global-end-of-process-errors logs file.
echo "${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}"
echo "${WGET_PROCESS_GLOBAL_ERRORS_MESSAGE}"  >> "${LOG_WGET_ROOTFOLDER_FULLPATH}/${LOG_WGET_GLOBAL_END_OF_PROCESS_ERRORS_FILE_NAME}"

# Exit if there was some error.
if [ ! "x${WGET_PROCESS_IS_WITH_NO_ERROR}" = "x1" ]
then
	exit -18
fi

echo
echo ========================================================================================
echo
echo "End of WGet process. ### NOT_USED A_VIRER : Will do the cleaning."
echo

################ ### NOT_USED A_VIRER 


echo "### NOT_USED A_VIRER     Now, will do the cleaning the WGet addons (meta, comments)."
echo "### NOT_USED A_VIRER     This is launched in another script, that does not echo the logs, but only put them in the dedicated log file."

LOG_DATETIMESTAMP=`date +%Y-%m-%d_%Hh%Mm` 	# same time stamps for both log files. Datestamp e.g 2002-09-21
# Do the cleaning of the Html files, for the WGet addons.
# "TCHA" <=> "TO_CLEAN_WGET_ADDONS"  (TCHA)
export DEST_OUTPUT_FOLDER_TO_CLEAN_WGET_ADDONS_NAME_GEN="$DEST_OUTPUT_FOLDER_FULLPATH_GEN"
export LOG_TCHA_MAINFOLDER="$LOG_WGET_ROOTFOLDER_FULLPATH"
export LOG_TCHA_GEN_PREFIX_FILE_NAME="wget-log-gen-for-cleaning-wget-addons"
export LOG_TCHA_ERR_PREFIX_FILE_NAME="wget-log-error-for-cleaning-wget-addons"
export LOG_TCHA_DATETIMESTAMP="$LOG_DATETIMESTAMP"

# echo "LOG_TCHA_GEN_PREFIX_FILE_NAME              = $LOG_TCHA_GEN_PREFIX_FILE_NAME"

### NOT_USED A_VIRER 
### $SCRIPT_WEBSITE_COPIER_HOME_DIR/XXXXXXXXXXXXXXX-launch-40-clean-wget-meta-and-comments-addons-gen.sh

echo
echo "### NOT_USED A_VIRER     End of the cleaning the WGet addons (meta, comments)."


