#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#************************ SHA256 Hash checksum of the folder of files ************************
# Make the SHA256 Hash checksum of the file, in recursive folders.
# Store the result in the Checksum result file.
# TRY_AND_SHOW_ONLY=show_only : show the the checksum values, no write in the Checksum result file.
#**********************************************************************

#****************************** Version ******************************
# V_0_1_0 - Version-220413
#*********************************************************************

# Several copies of this script file are spreaded in several folders.
# They usually have the same name, or with some prefix or suffix.
# They are the same. The original one is in the main general scrip lib folder.

# For the Sha command for the folder, see : 
# https://askubuntu.com/questions/1091335/create-checksum-sha256-of-all-files-and-directories#1091369
# For an example of checksum with PGP verification (signature), see :
# https://getfedora.org/en/security/

# See : http://www.liamdelahunty.com/tips/linux_rename_files.php

# Save the original folder.
SCRIPTCTXT_DIRNAME_ORIGINAL=`pwd`
# For debug. Set it to "true" to activate the mode debug.
SCRIPTCTXT_DEBUG="false"
### SCRIPTCTXT_DEBUG="true"

# First parameter must be the FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH. The script will cd to this folder, before to execute the find command and the checksum of the files.
# Second parameter must be the find command options. As an example : "." -name "*"  -wholename "*Paquet_de_CRIs_local-2022_04_13-07h30m13s*"  -type f.
# Third parameter must be the fullpath folder and file name, for the Checksum result file.
# Fourth parameter shall be the fullpath folder and file name, for the log_gen file (not mandatory, use "" for no logging in file).
# Fifth parameter  shall be the fullpath folder and file name, for the log_error file (not mandatory, use "" for no logging in file).
# Sixth parameter shall be "show_only" or "NOT_show_only" for TRY_AND_SHOW_ONLY of the checksum values (no write in the Checksum result file).
# Seventh parameter shall be the debug option (SCRIPTCTXT_DEBUG) (default is "false").

FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH=$1
FOLDERSORFILES_FIND_COMMAND_OPTIONS=$2
CHECKSUM_RESULT_FILE_FULLPATH_AND_FILE_NAME=$3
LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE=$4
LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE=$5
TRY_AND_SHOW_ONLY=$6
SCRIPTCTXT_DEBUG=$7

#*********************************************************************
# Logging and logger feature.
#*********************************************************************
logging_string_to_loggenfile()
{
echo "${1}"
if [ ! "x${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}" = "x" ]
then
	echo "${1}" >> "${LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE}"
fi

}
logging_string_to_logerrorfile()
{
echo "${1}" 
if [ ! "x${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}" = "x" ]
then
	echo "${1}" >> "${LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE}"
fi
}


if [ "$#" -lt 3 ]
then
	logging_string_to_logerrorfile "ERROR : there should be at least 3 parameters to launch this script! not only : [$#]."
	exit -1;
fi

if [ ! "x$TRY_AND_SHOW_ONLY" = "xshow_only" ] && [ ! "x$TRY_AND_SHOW_ONLY" = "xNOT_show_only" ]
then
	if [ ! "$TRY_AND_SHOW_ONLY" = "" ]
	then
		logging_string_to_logerrorfile "ERROR : the option should be 'show_only' and not any other word! Not [$TRY_AND_SHOW_ONLY]."
		exit -1
	fi
fi

if [ "x${SCRIPTCTXT_DEBUG}" = "x" ]
then
	SCRIPTCTXT_DEBUG="false"
fi
	
if [ ! "x$SCRIPTCTXT_DEBUG" = "xtrue" ]
then
	if [ ! "$SCRIPTCTXT_DEBUG" = "false" ]
	then
		logging_string_to_logerrorfile "ERROR : the option should be 'true' or 'false' but not any other word! Not [$SCRIPTCTXT_DEBUG]."
		exit -1
	fi
fi

logging_string_to_loggenfile
logging_string_to_loggenfile "Make the Checksum SHA256 of the file, with recursive search in the folders."
logging_string_to_loggenfile
### logging_string_to_loggenfile "SCRIPTCTXT_DEBUG=$SCRIPTCTXT_DEBUG"
	
# The original folder have been saved in SCRIPTCTXT_DIRNAME_ORIGINAL
# This is necessary, to have the find command work properly.
# If not, it may add the root folder itself in the list of folders and files to modify.
cd "${FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH}"

if [ "x${SCRIPTCTXT_DEBUG}" = "xtrue" ]
then
	# For debug.
	logging_string_to_loggenfile "For debug."
	logging_string_to_loggenfile "FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH=$FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH"
	logging_string_to_loggenfile "FOLDERSORFILES_FIND_COMMAND_OPTIONS=$FOLDERSORFILES_FIND_COMMAND_OPTIONS"
	logging_string_to_loggenfile "CHECKSUM_RESULT_FILE_FULLPATH_AND_FILE_NAME=$CHECKSUM_RESULT_FILE_FULLPATH_AND_FILE_NAME"
	logging_string_to_loggenfile "LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE=$LOG_GEN_FULLPATH_AND_FILE_NAME_TO_USE"
	logging_string_to_loggenfile "LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE=$LOG_ERR_FULLPATH_AND_FILE_NAME_TO_USE"
	logging_string_to_loggenfile "TRY_AND_SHOW_ONLY=$TRY_AND_SHOW_ONLY"
	logging_string_to_loggenfile "SCRIPTCTXT_DEBUG=$SCRIPTCTXT_DEBUG"
fi

# sample of command : 
# find /my_path -type f -user $USER  "desktop.ini" -exec ls -f {} \;
# Note : the anti-slash at the end in the string of COMMAND_CHECKSUM_BUILDER.
### COMMAND_CHECKSUM_BUILDER="find $FILES_PATH -name $FILES_PATTERN -exec rm -f {} \;"
### logging_string_to_loggenfile "command : $COMMAND_CHECKSUM_BUILDER"

# with find command 
# The folder have been changed to "$FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH"
# This is necessary, to have the find command work properly. 
# If not, it may add the root folder itself in the list of folders and files to modify.
if [ "x${TRY_AND_SHOW_ONLY}" = "xshow_only" ] 
then
	# Trials and Show Only.
	logging_string_to_loggenfile
	logging_string_to_loggenfile "For Trials and Show Only."
	logging_string_to_loggenfile "The Checksum is only shown (echo), and not written in the Checksum result file."
	logging_string_to_loggenfile ""
	logging_string_to_loggenfile ""

COMMAND_CHECKSUM_BUILDER="find ${FOLDERSORFILES_FIND_COMMAND_OPTIONS} -print0 | xargs -0 sha256sum "
###  > \"${CHECKSUM_RESULT_FILE_FULLPATH_AND_FILE_NAME}\" "

### logging_string_to_loggenfile
### logging_string_to_loggenfile "FOLDERSORFILES_FIND_COMMAND_OPTIONS=""${FOLDERSORFILES_FIND_COMMAND_OPTIONS}"""
### logging_string_to_loggenfile "cd ""${FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH}"" "
### logging_string_to_loggenfile "command : $COMMAND_CHECKSUM_BUILDER"
### logging_string_to_loggenfile

# ${COMMAND_CHECKSUM_BUILDER}
eval ${COMMAND_CHECKSUM_BUILDER}
# find ${FOLDERSORFILES_FIND_COMMAND_OPTIONS} -print0 | xargs -0 sha256sum

	logging_string_to_loggenfile
	logging_string_to_loggenfile
	logging_string_to_loggenfile "For Trials and Show Only. END OF PROCESS."
	logging_string_to_loggenfile

else

	# The folder have been changed to "$FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH"
	# This is necessary, to have the find command work properly. 
	# If not, it may add the root folder itself in the list of folders and files to modify.

	if [ "x${SCRIPTCTXT_DEBUG}" = "xtrue" ]
	then
		# For debug.
		logging_string_to_loggenfile "Start the find and checksum process."
	fi

	COMMAND_CHECKSUM_BUILDER="find ${FOLDERSORFILES_FIND_COMMAND_OPTIONS} -print0 | xargs -0 sha256sum > \"${CHECKSUM_RESULT_FILE_FULLPATH_AND_FILE_NAME}\" "

	logging_string_to_loggenfile
	logging_string_to_loggenfile "cd \"${FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH}\" "
### logging_string_to_loggenfile "cd ""${FILES_TO_CHECKSUM_BASE_ROOT_FOLDER_FULLPATH}"" "
	logging_string_to_loggenfile "command : $COMMAND_CHECKSUM_BUILDER"
	logging_string_to_loggenfile

	# ${COMMAND_CHECKSUM_BUILDER}
	eval ${COMMAND_CHECKSUM_BUILDER}
	# find ${FOLDERSORFILES_FIND_COMMAND_OPTIONS} -print0 | xargs -0 sha256sum > "${CHECKSUM_RESULT_FILE_FULLPATH_AND_FILE_NAME}"
	
	if [ "x${SCRIPTCTXT_DEBUG}" = "xtrue" ]
	then
		# For debug.
		logging_string_to_loggenfile
		logging_string_to_loggenfile "END OF PROCESS."
		logging_string_to_loggenfile
	fi
fi

cd "${SCRIPTCTXT_DIRNAME_ORIGINAL}"


