#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#************************ Prepare for prod the PackageOfCRIs ************************
# Copy and clean the file retrieved by HTTrack, 
# then add the main index.html page, at the root folder of the Paquet-de-CRIs.
#**********************************************************************

logging_string_to_loggenfile "Put the files from the Data Workspace Httrack retrieval folder, into the Data Workspace prepa_10_cleaningfiles folder. Remove 3 files not needed."
logging_string_to_loggenfile ""
mkdir -p "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}"
chown "${UG_GENPROCESS_USER_NAME}:${UG_GENPROCESS_GROUP_NAME}" "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}"

# Copy the files from the Data Workspace folder, into the Data Workspace prepa_10_cleaningfiles folder.
cp -rp "${PAQDECRIS_BUILD_DATA_WKSP_WEBSITERETRIEVED_FULLPATH_CURRENT_FOLDER}"  "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}"
TEMP_SCRIPT_EXIT_CODE_1=$?
# Erase the 3 files that are not needed in the Paquet-de-CRIs. 
# Those are the files for the HTTrack presentation of the web sites that have been copied.
#rm -f "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}/backblue.gif" 
rm -f "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/backblue.gif"  "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/fade.gif"  "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/index.html"
TEMP_SCRIPT_EXIT_CODE_2=$?

# Add the main index.html in the root folder of the Paquet-de-CRIs.
# The source top index.html file.
PAQDECRIS_SOURCE_DATA_TOPSRCINDEXHTML_FILE_NAME="index-for-main-page-of-Paquet-de-CRIs.html"
PAQDECRIS_SOURCE_DATA_TOPSRCINDEXHTML_FULLPATH_FOLDER_AND_FILE_NAME="${SCRIPT_HOME_DIR}/FactPackCris_310_Content_Html_Pages/${PAQDECRIS_SOURCE_DATA_TOPSRCINDEXHTML_FILE_NAME}"

# The result top-paquet-index.html file. In PREPA_10_CLEANINGFILES folder.
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_TOPINDEXHTML_FILE_NAME="index.html"
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_TOPINDEXHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_TOPINDEXHTML_FILE_NAME}"

# Copy the files from the SourceData folder, into the PREPA_10_CLEANINGFILES folder.
cp -p "${PAQDECRIS_SOURCE_DATA_TOPSRCINDEXHTML_FULLPATH_FOLDER_AND_FILE_NAME}"  "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_TOPINDEXHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"
TEMP_SCRIPT_EXIT_CODE_3=$?

# Modify the content of the top-paquet-index.html file, so it has the value of the proper label and folder for this current Paquet-de-CRIs, in it.
sed -i "s/PAQDECRIS_SUBST_TAG_PATH_RELATIVE_TO_MAIN_WWW_FOLDER/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}\/www.les-cris.com/g" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_TOPINDEXHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"
TEMP_SCRIPT_EXIT_CODE_4=$?

sed -i "s/PAQDECRIS_SUBST_TAG_TOPROOT_FOLDER_NAME/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/g" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_TOPINDEXHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"
TEMP_SCRIPT_EXIT_CODE_5=$?

sed -i "s/PAQDECRIS_SUBST_TAG_PAQUETDECRIS_LABEL_BASE_GENERAL/${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}/g" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_TOPINDEXHTML_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"
TEMP_SCRIPT_EXIT_CODE_6=$?


