#!/bin/sh
#******************************* License GPLv3 ********************************
# Factory_paquets_de_CRIs_gen : Factory to build one paquet-de-CRIs from the website www.les-cris.com, with a timestamp, and and a SHA256 signature of the package.
# Copyright (C) 2022  Antoine Herzog <info -!at-arobase=! les-cris -!dot-point=! com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
#******************************************************************************

#************************ Prepare for prod the PackageOfCRIs ************************
# Build the package, as xz compressed file - tar.gz and zip files.
#**********************************************************************
logging_string_to_loggenfile ""
logging_string_to_loggenfile "Build the package, as xz compressed file - tar.gz and zip files."

#*********************************************************************
# The variable for the process. 
#*********************************************************************
# For the XZ Paquet File.
# The files names for the xz compressed files of the paquet-de-CRIs.
# Compressed file name for the compressed-package-file with xz compression :
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_XZ_PAQUET_FILE_NAME="${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}-xz-paquet.tar.xz"
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_XZ_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_XZ_PAQUET_FILE_NAME}"

# Checksum file for the compressed-package-file with xz compression :
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_XZ_PAQUET_FILE_NAME="${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}-xz-paquet-CHECKSUM"
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_XZ_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_XZ_PAQUET_FILE_NAME}"

# For the Zip Paquet File.
# The files names for the zip compressed files of the paquet-de-CRIs.
# Compressed file name for the compressed-package-file with zip compression :
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_ZIP_PAQUET_FILE_NAME="${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}-zip-paquet.zip"
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_ZIP_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_ZIP_PAQUET_FILE_NAME}"

# Checksum file for the compressed-package-file with zip compression :
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_ZIP_PAQUET_FILE_NAME="${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}-zip-paquet-CHECKSUM"
PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_ZIP_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME="${PAQDECRIS_BUILD_DATA_PACKS_FINAL_PRODUCTION_STORAGE_FULLPATH_CURRENT_FOLDER}/${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_ZIP_PAQUET_FILE_NAME}"


# Build the package, as xz compressed file - tar.gz file.

# -C , --directory DOSSIER : Exécute la commande à partir du répertoire DOSSIER
# See : https://stackoverflow.com/questions/939982/how-do-i-tar-a-directory-of-files-and-folders-without-including-the-directory-it#3035446
logging_string_to_loggenfile "For debug."
logging_string_to_loggenfile "tar -cJf ""${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_XZ_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"" -C ""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}"" ""${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}"" -C ""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUMUNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER}""
""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUM_UNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"" "
logging_string_to_loggenfile ""

tar -cJf "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_XZ_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}" -C "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}" "${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}" "index.html" -C "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUMUNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER}" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_UNCOMPRESSEDFOLDER_FILE_NAME}"

TEMP_SCRIPT_EXIT_CODE_1=$?

# Build the package, as compressed file - zip file.
# About the folder path inside the zip, see :
# https://askubuntu.com/questions/521011/zip-an-archive-without-including-parent-directory
# -r , --recurse-paths : Travel the directory structure recursively
# Tip : (cd directory && zip -r ../out.zip .)
# It keeps the main shell in the same directory and only changing the directory of the sub-shell which dies after the command.

# To keep the folder before the processing (that will need to cd to other folder).
SCRIPT_PREPAFORPROD_PROCESSING_HOME_DIR="$( pwd )"

logging_string_to_loggenfile "For debug."
logging_string_to_loggenfile "cd ""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}"" "
logging_string_to_loggenfile "zip -r ""${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_ZIP_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"" ""${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}"" "
logging_string_to_loggenfile "cd ""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUMUNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER}"" "
logging_string_to_loggenfile "zip -r ""${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_ZIP_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"" ""${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}""
""${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUM_UNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}"" "
logging_string_to_loggenfile ""

cd "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_10_CLEANINGFILES_FULLPATH_CURRENT_FOLDER}"
zip -r --quiet "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_ZIP_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}" "${PAQDECRIS_BUILD_DATA_PRODSTORE_PACKAGEOFCRIS_CURRENT_FOLDER_NAME}"  "index.html" 

cd "${PAQDECRIS_BUILD_DATA_WKSP_PREPA_20_CHECKSUMUNCOMPRESSEDFOLDER_FULLPATH_CURRENT_FOLDER}"
zip --quiet "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_COMPRESSED_ZIP_PAQUET_FULLPATH_CURRENT_FOLDER_AND_FILE_NAME}" "${PAQDECRIS_BUILD_DATA_PACKAGEOFCRIS_CHECKSUM_UNCOMPRESSEDFOLDER_FILE_NAME}"


# cd back to the former folder.
cd "${SCRIPT_PREPAFORPROD_PROCESSING_HOME_DIR}"

TEMP_SCRIPT_EXIT_CODE_2=$?




